require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);
SetGamePause(true);

kResultShop = 0;
kResultGame = 1;

function Expert( display )
    t = {};
    if ( display == 1 ) then
        table.insert(t, Bitmap
            {
                name="expert",
                image="ui/levelover/expert",
                x=kCenter+170,
                y=kCenter-120,
            });
    end;
    return Group(t);
end;

function TextExpert( display )
    t = {};
    if ( display == 1 ) then
        table.insert(t, 
                Text
                {
					font = { FontGame, 28, YellowColor },
                    x = 462, y = 122,
                    w = 200, h = 200,
                    flags = kHAlignCenter + kVAlignCenter,
                    rotation = -11,
                    label="expert_badge",
                });
    end;
    return Group(t);
end;

function TextExpertShadow( display )
    t = {};
    if ( display == 1 ) then
        table.insert(t, 
                Text
                {
					font = { FontGame, 28, BlackColor },
                    x = 464, y = 124,
                    w = 200, h = 200,
                    flags = kHAlignCenter + kVAlignCenter,
                    rotation = -11,
                    label="expert_badge",
                });
    end;
    return Group(t);
end;



MakeDialog
{
    CDPanelWinFP
    {
        name="panelwinfp",
        x = 0,
        y = 0,
        w = 800,
        h = 600,
        
        enter_curve = "config/curves/fx_start.xml",
        exit_curve = "config/curves/fx_end.xml",
        
        Bitmap
        {
            x=kCenter,y=kCenter-1000,
            w=800,h=600,
            name="panel",
            alpha = 1,
        
            Bitmap
            {
                name="infopanel",
                image="ui/levelover/levelover",
                x=kCenter,
                y=kCenter,
                
                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                -- number of served tables:
                CreateText(kCenter-80,kCenter-110,"#"..GetString("tables_served",GetCustomersServedStr()),0,0),
                -- number of lost tables:
                CreateText(kCenter,kCenter-110,"#"..GetString("tables_lost",GetCustomersLostStr()),0,0),
                -- current level number:
                --CreateText(kCenter+80,kCenter-110,"#"..GetString("level",GetCurrLevelNumStr()),0,0),

                SetStyle(CreateTextStyle(FontGame, 26, RedColor)),
                Text
                {-- text for winning the level
                    x=80,
                    y=255,
                    w=kMax-80,
                    h=kMax,
                    flags=kHAlignLeft+kVAlignTop,
                    label="story_winfp",
                },
                
                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                Text
                {-- text "score:"
                    x=kCenter+60,y=kCenter+122,
                    flags=kHAlignLeft+kVAlignCenter,
                    label="levelscore",
                },
                
                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                Text
                {-- score value
                    x=kCenter+125,y=kCenter+122,
                    flags=kHAlignLeft+kVAlignCenter,
                    label=GetLevelScore(),
                },

                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                Text
                {-- text "Total:"
                    x=kCenter+60,y=kCenter+142,
                    flags=kHAlignLeft+kVAlignCenter,
                    label="totalscore",
                },
                
                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                Text
                {-- total score value
                    x=kCenter+125,y=kCenter+142,
                    flags=kHAlignLeft+kVAlignCenter,
                    label=GetHighScore(),
                },
                
                SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
                Button
                {
                    x=kCenter,
                    y=kCenter + 185,
                    name="continue",
                    default = true,
                    command=
                        function()
                            HideWinFPPanel();
                        end,
				    SetStyle(CreateTextStyle(FontGame, 20, WhiteColor)),
				    CreateText(2,2,"ok", 0, 0),
				    SetStyle(CreateTextStyle(FontGame, 20, BlackColor)),
				    CreateText(0,0,"ok", 0, 0),
                },
            },
            
            Bitmap
            {-- picture with happy flo
                name="win",
                image="ui/levelover/flo_win",
                x=kCenter-250,
                y=kCenter,
            },
            Expert( GetExpertAchieved() ),
            TextExpertShadow( GetExpertAchieved() ),
            TextExpert( GetExpertAchieved() ),
        },
    },
}